TRUNCATE TABLE EST_PED_CP_ORC_FINAN_PROC_PENDENTE
GO
INSERT INTO EST_PED_CP_ORC_FINAN_PROC_PENDENTE
SELECT
    CD_EMP,
    CD_FILIAL,
    CD_PED,
    GETDATE(),
    GETDATE()
FROM
    EST_PED_CP_PENDENCIA
GO
/****** Object:  StoredProcedure [dbo].[P_EST_PROD_PENDENCIA_ENTRADA]    Script Date: 06/21/2013 12:40:40 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PENDENCIA_ENTRADA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PENDENCIA_ENTRADA]
GO
GO
--exec P_EST_PROD_PENDENCIA_ENTRADA
CREATE PROCEDURE [dbo].[P_EST_PROD_PENDENCIA_ENTRADA] @CD_EMP INT=1 AS
	DECLARE @CD_FILIAL AS INT
	
	declare @msg varchar(100);
	SET NOCOUNT ON

BEGIN TRY

EXEC P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_ERROS
EXEC P_EST_PROD_REQ_TRANSF_LIB_CONFERENCIA 3

Print 'Analisando pendencia de entrada vinculada '  + convert(varchar, getdate(),108)
DELETE
	EST_PED_CP_VINCULADA
WHERE
	CD_FILIAL = CD_FILIAL_VINCULADA
	
--Analisando pendencia vinculada entre filiais
INSERT INTO EST_PED_CP_VINCULADA
(CD_EMP,
CD_FILIAL,
CD_PED,
CD_FILIAL_VINCULADA,
CD_USU,
DT_CAD)
SELECT
	EST_PED_ELTR_FORN_PED_CP.CD_EMP,
	EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR,
	EST_PED_ELTR_FORN_PED_CP.CD_PED,
	EST_PED_ELTR.CD_FIL_ENTR,
	EST_PED_ELTR.CD_USU,
	CONVERT(CHAR(10), GETDATE(),112)
FROM
	EST_PED_ELTR_UNI INNER JOIN EST_PED_ELTR_FORN_PED_CP ON
	EST_PED_ELTR_UNI.CD_EMP = EST_PED_ELTR_FORN_PED_CP.CD_EMP AND
	EST_PED_ELTR_UNI.CD_PED_SOL_UNI = EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL
	INNER JOIN EST_PED_ELTR ON
	EST_PED_ELTR_UNI.CD_EMP = EST_PED_ELTR.CD_EMP AND
	EST_PED_ELTR_UNI.CD_PED_SOL = EST_PED_ELTR.CD_PED_SOL
	LEFT OUTER JOIN EST_PED_CP_VINCULADA ON
	EST_PED_CP_VINCULADA.CD_EMP = EST_PED_ELTR_FORN_PED_CP.CD_EMP AND
	EST_PED_CP_VINCULADA.CD_FILIAL = EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR AND
	EST_PED_CP_VINCULADA.CD_PED = EST_PED_ELTR_FORN_PED_CP.CD_PED
	INNER JOIN EST_PED_CP_PENDENCIA ON
	EST_PED_ELTR_FORN_PED_CP.CD_EMP = EST_PED_CP_PENDENCIA.CD_EMP AND
	EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR = EST_PED_CP_PENDENCIA.CD_FILIAL AND
	EST_PED_ELTR_FORN_PED_CP.CD_PED = EST_PED_CP_PENDENCIA.CD_PED

WHERE
    EST_PED_CP_VINCULADA.CD_PED IS NULL
	AND EST_PED_ELTR_UNI.PEND_VINCULADA=1;


	DECLARE cFilialPendencia CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE
		STS_FILIAL=0
		AND CD_EMP=@CD_EMP
	ORDER BY CD_FILIAL
	
	OPEN cFilialPendencia
	FETCH NEXT FROM cFilialPendencia INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
	 
		SET @msg = 'Rotina de pendencia de entradas ' + convert(varchar, getdate(),108);
		Print 'Atualizando Filial ..: ' + convert(varchar, @CD_FILIAL) + ' '	
		Raiserror (@msg, 0, 1) with nowait
		--Remove danfes pendencia		
		DELETE FROM P
		FROM 
			EST_NF_ENT_DANFE_PROVISORIO_PENDENTE P
			JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT E ON 
				P.CD_CTR=E.CD_CTR
		WHERE 
			E.CD_EMP=@CD_EMP
			AND E.CD_FILIAL=@CD_FILIAL;

		EXECUTE dbo.P_EST_PROD_PENDENCIA_ENTRADA_FILIAL @CD_EMP, @CD_FILIAL;
	
		FETCH NEXT FROM  cFilialPendencia INTO @CD_FILIAL 
	END

    CLOSE cFilialPendencia
    DEALLOCATE cFilialPendencia

Print 'Trantando pendencia de geracao orcamento de compras ' + convert(varchar, getdate(),108)
--Tratando a pendencia de processamento do orcamento de compras
CREATE TABLE #RsPedido (CD_EMP INT,
				   CD_FILIAL INT,
				   CD_PED INT)

INSERT INTO #RsPedido
	SELECT  
		CD_EMP,
		CD_FILIAL,
		CD_PED
	FROM
		EST_PED_CP_ORC_FINAN_PROC_PENDENTE
	WHERE 
	   CD_EMP=@CD_EMP;

CREATE UNIQUE CLUSTERED INDEX #ix__RsPedido on #RsPedido (cd_emp, cd_ped, cd_filial)
 
--Deletando movimento a ser processado

Print 'Deletando movimento a ser processado  ' + convert(varchar, getdate(),108)
DELETE
	PG_FORN_PG_CRED_SALDO_ABERTO
FROM
	PG_FORN_PG_CRED_SALDO_ABERTO a 
	INNER JOIN EST_PED_CP p ON
	a.CD_EMP = p.CD_EMP AND
	a.DT_MOV = p.DT_EMI AND
	a.CD_FORN = p.CD_FORN 
	INNER JOIN #RsPedido pe ON
	p.CD_EMP = pe.CD_EMP AND
	p.CD_FILIAL = pe.CD_FILIAL AND 
	p.CD_PED = pe.CD_PED 
WHERE
	a.TP_TRANSACAO = 1
	and p.cd_emp=@CD_EMP

	
Print 'linha 138 ' + convert(varchar, getdate(),108)
INSERT INTO PG_FORN_PG_CRED_SALDO_ABERTO    (DT_MOV,CD_EMP,CD_FORN,
									   VLR_EM_ABERTO,DT_PROC,CD_BANDEIRA,TP_TRANSACAO)
SELECT
	a.DT_EMI,
	a.CD_EMP,
	a.CD_FORN,
	SUM(a.VLR_PED) AS VLR_PED,
	GETDATE(),
	PRC_BANDEIRA_PRC_FILIAL.CD_BANDEIRA,
	1
FROM
	EST_PED_CP A
	INNER JOIN #RsPedido p ON
	a.CD_EMP = p.CD_EMP AND
	a.CD_FILIAL = p.CD_FILIAL AND
	a.CD_PED = p.CD_PED 
	join pg_forn f on 
	A.CD_EMP = f.CD_EMP AND
	A.CD_FORN = f.CD_FORN  
	INNER JOIN PRC_BANDEIRA_PRC_FILIAL ON
	a.CD_EMP =PRC_BANDEIRA_PRC_FILIAL.CD_EMP AND
	a.CD_FILIAL = PRC_BANDEIRA_PRC_FILIAL.CD_FILIAL 
WHERE
    a.CD_EMP = @CD_EMP
GROUP BY
	a.DT_EMI,
	a.CD_EMP,
	a.CD_FORN,
	PRC_BANDEIRA_PRC_FILIAL.CD_BANDEIRA;

Print 'linha 169 ' + convert(varchar, getdate(),108)
--Deletando pendencia
DELETE 
	pend
FROM
	EST_PED_CP_ORC_FINAN_PROC_PENDENTE pend INNER JOIN #RsPedido p ON
	pend.CD_EMP = p.CD_EMP AND
	pend.CD_FILIAL = p.CD_FILIAL AND
	pend.CD_PED = p.CD_PED 
WHERE 
    PEND.CD_EMP = @CD_EMP


END TRY 
BEGIN CATCH
    DECLARE	
		  @mensagemErro	  VARCHAR(255),
		  @severidadeErro	  INT,
		  @estadoErro		  INT;		
    SELECT	@mensagemErro = ERROR_MESSAGE(), 
			@severidadeErro = ERROR_SEVERITY(), 
			@estadoErro = ERROR_STATE();
    
    INSERT INTO ADM_ERRO (numero , severidade , estado , 
					   rotina , linha , mensagem , dtErro)
			   SELECT ERROR_NUMBER() AS numero
					, @severidadeErro AS severidade
					, @estadoErro AS estado
					, 'Rotina P_EST_PROD_PENDENCIA_ENTRADA ' AS rotina
					, ERROR_LINE() AS linha
					, @mensagemErro  AS mensagem
					, GETDATE() AS dtErro; 
    RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
END CATCH 